:setvar DatabaseName "Registry"

------------------------------------------
-- 2.0.32.2
------------------------------------------
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "32"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.32.2.sql"

print ' 
------------------------------------------------------------------------------------------------
Rollback $(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
print 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
print ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
go
:on error exit
go
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
set noexec off; 
go
if N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        print N'SQLCMD mode must be enabled to successfully execute this script.';
        set NOEXEC ON; --When set NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    end

go

use [$(DatabaseName)]
GO

--**************
--Rollback steps
--**************
--
if exists (select * from sys.indexes where name = 'IX_StdFormAnswer_StdFormQuestion')
  drop index IX_StdFormAnswer_StdFormQuestion ON AHOBPR.STD_FORM_ANSWER;
go
if exists (select * from sys.indexes where name = 'IX_StdFormAnswer_BRPFormAnswerId')
  drop index IX_StdFormAnswer_BRPFormAnswerId on AHOBPR.STD_FORM_ANSWER;
go

if exists (select * from sys.procedures where name = 'SP_ReportRegistrantContact_pre_2_0_32_2'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
begin
  if exists (select * from sys.procedures where name = 'SP_ReportRegistrantContact'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
    drop procedure ahobpr.SP_ReportRegistrantContact;
  exec sp_rename 'ahobpr.SP_ReportRegistrantContact_pre_2_0_32_2', 'SP_ReportRegistrantContact'
end;
go
if exists (select * from sys.procedures where name = 'SP_GetRegistrantSendQuestions_pre_2_0_32_2'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
begin
  if exists (select * from sys.procedures where name = 'SP_GetRegistrantSendQuestions'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
    drop procedure ahobpr.SP_GetRegistrantSendQuestions;
  exec sp_rename 'ahobpr.SP_GetRegistrantSendQuestions_pre_2_0_32_2', 'SP_GetRegistrantSendQuestions'
end;
go

if exists (select * from sys.procedures where name = 'SP_GetRegistrantSendMessage_pre_2_0_32_2'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
begin
  if exists (select * from sys.procedures where name = 'SP_GetRegistrantSendMessage'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
    drop procedure ahobpr.SP_GetRegistrantSendMessage;
  exec sp_rename 'ahobpr.SP_GetRegistrantSendMessage_pre_2_0_32_2', 'SP_GetRegistrantSendMessage'
end;
go

if exists (select * from sys.procedures where name = 'SP_ReportAdHocByLocation_pre_2_0_32_2'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
begin
  if exists (select * from sys.procedures where name = 'SP_ReportAdHocByLocation'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
    drop procedure ahobpr.SP_ReportAdHocByLocation;
  exec sp_rename 'ahobpr.SP_ReportAdHocByLocation_pre_2_0_32_2', 'SP_ReportAdHocByLocation'
end;

go

if exists (select * from sys.procedures where name = 'SP_ReportAdHocByIndividual_pre_2_0_32_2'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
begin
  if exists (select * from sys.procedures where name = 'SP_ReportAdHocByIndividual'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
    drop procedure ahobpr.SP_ReportAdHocByIndividual;
  exec sp_rename 'ahobpr.SP_ReportAdHocByIndividual_pre_2_0_32_2', 'SP_ReportAdHocByIndividual'
end;

print N'Rollback complete.';
GO

delete 
  from [dbo].[DatabaseChangeLog]
  where [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    and [PointReleaseNumber] = '$(PointReleaseNumber)'
    and [ScriptName]         = '$(ScriptName)';
GO


-------------------------------------------
---- END ROLLBACK 
-------------------------------------------
--SELECT 'Last script run and not rolled back',*
--FROM [dbo].[DatabaseChangeLog]
--WHERE  [DatabaseChangeID] = (
--                              SELECT MAX([DatabaseChangeID]) FROM [dbo].[DatabaseChangeLog]
--                              WHERE TargetRegistry        = 'AHOBPR'
--                             );

------------------------------------------
-- 2.0.32.1
------------------------------------------
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "32"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.32.1.sql"

print ' 
------------------------------------------------------------------------------------------------
Rollback $(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
print 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
print ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
go
:on error exit
go
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
set noexec off; 
go
if N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        print N'SQLCMD mode must be enabled to successfully execute this script.';
        set NOEXEC ON; --When set NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    end

go

use [$(DatabaseName)]
GO

--**************
--Rollback steps
--**************
--

if exists (select * from sys.procedures where name = 'SP_GetRegistrantAddFlag_pre_2_0_32_1'
                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                  )
begin
  if exists(select * from sys.procedures where name = 'SP_GetRegistrantAddFlag'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
    drop procedure AHOBPR.SP_GetRegistrantAddFlag;

  exec sp_rename 'AHOBPR.SP_GetRegistrantAddFlag_pre_2_0_32_1','SP_GetRegistrantAddFlag';
end;

if exists (select * from sys.procedures where name = 'SP_GetRegistrantSendMessage_pre_2_0_32_1'
                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                  )
begin
  if exists(select * from sys.procedures where name = 'SP_GetRegistrantSendMessage'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
    drop procedure AHOBPR.SP_GetRegistrantSendMessage;

  exec sp_rename 'AHOBPR.SP_GetRegistrantSendMessage_pre_2_0_32_1','SP_GetRegistrantSendMessage';
end;


GO

if exists (select * from sys.procedures where name = 'SP_ReportAdHocByIndividual_pre_2_0_32_1'
                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                  )
begin
  if exists(select * from sys.procedures where name = 'SP_ReportAdHocByIndividual'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
    drop procedure AHOBPR.SP_ReportAdHocByIndividual;

  exec sp_rename 'AHOBPR.SP_ReportAdHocByIndividual_pre_2_0_32_1','SP_ReportAdHocByIndividual';
end;

if exists (select * from sys.procedures where name = 'SP_ReportRegistrantContact_pre_2_0_32_1'
                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                  )
begin
  if exists(select * from sys.procedures where name = 'SP_ReportRegistrantContact'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
    drop procedure AHOBPR.SP_ReportRegistrantContact;

  exec sp_rename 'AHOBPR.SP_ReportRegistrantContact_pre_2_0_32_1','SP_ReportRegistrantContact';
end;

print N'Rollback complete.';
GO

delete 
  from [dbo].[DatabaseChangeLog]
  where [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    and [PointReleaseNumber] = '$(PointReleaseNumber)'
    and [ScriptName]         = '$(ScriptName)';
GO


-------------------------------------------
---- END ROLLBACK 
-------------------------------------------
--SELECT 'Last script run and not rolled back',*
--FROM [dbo].[DatabaseChangeLog]
--WHERE  [DatabaseChangeID] = (
--                              SELECT MAX([DatabaseChangeID]) FROM [dbo].[DatabaseChangeLog]
--                              WHERE TargetRegistry        = 'AHOBPR'
--                             );
go
------------------------------------------
-- 2.0.30.1
------------------------------------------
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "30"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.30.1.sql"

print ' 
------------------------------------------------------------------------------------------------
Rollback $(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
print 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
print ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
go
:on error exit
go
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
set noexec off; 
go
if N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        print N'SQLCMD mode must be enabled to successfully execute this script.';
        set NOEXEC ON; --When set NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    end

go

use [$(DatabaseName)]
GO

--**************
--Rollback steps
--**************
--
    
if exists (select * from sys.views where name = 'view_lookup_pre_2_0_30'
                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                  )
begin
  if exists(select * from sys.views where name = 'VIEW_LOOKUP'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
    drop view AHOBPR.VIEW_LOOKUP;

  exec sp_rename 'AHOBPR.view_lookup_pre_2_0_30','VIEW_LOOKUP';
end;

go

print N'Rollback complete.';
GO

delete 
  from [dbo].[DatabaseChangeLog]
  where [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    and [PointReleaseNumber] = '$(PointReleaseNumber)'
    and [ScriptName]         = '$(ScriptName)';
GO

------------------------------------------
-- 2.0.24.1
------------------------------------------
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "24"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.24.1.sql"

print ' 
------------------------------------------------------------------------------------------------
Rollback $(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
print 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
print ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
go
:on error exit
go
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
set noexec off; 
go
if N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        print N'SQLCMD mode must be enabled to successfully execute this script.';
        set NOEXEC ON; --When set NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    end

go

use [$(DatabaseName)]
GO

--**************
--Rollback steps
--**************
--
update  [dbo].[DatabaseChangeLog]
  set [ScriptDescription] = 'Rollback initiated...'
  where [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    and [PointReleaseNumber] = '$(PointReleaseNumber)'
    and [ScriptName]         = '$(ScriptName)';
go
set ansi_nulls, ansi_padding, ansi_warnings, arithabort, concat_null_yields_null, quoted_identifier on;

set numeric_roundabort off;

go
if exists(select * from sys.views where name = 'view_lookup_pre2_0_24_1'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR'))
begin
    if exists (select * from sys.views where name = 'VIEW_LOOKUP'
              and schema_id = (select schema_id from sys.schemas where name = 'ahobpr')
            )
    drop view [AHOBPR].[VIEW_LOOKUP];
  exec sp_rename 'ahobpr.view_lookup_pre2_0_24_1','VIEW_LOOKUP' ;
end;

go


declare  @RegistryId int = (select ID from [dbo].[STD_REGISTRY] where [CODE] = N'AHOBPR');
declare  @Today datetime = getdate();

if exists (select * from sys.tables where name = 'std_gui_controls_pre2_0_24_1'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR'))
begin
  delete from [dbo].[STD_GUI_CONTROLS] where [STD_REGISTRY_ID] = @RegistryId;

  insert 
    into [dbo].[STD_GUI_CONTROLS]
          (
           [STD_REGISTRY_ID]
          ,[CATEGORY]
          ,[NAME]
          ,[BASE_CONTROL_TYPE]
          ,[USER_CONTROL_ID]
          ,[VALIDATION_ERROR_MESSAGE]
          ,[VALIDATION_REGULAR_EXPRESSION]
          ,[TOOL_TIP]
          ,[SORT_ORDER]
          ,[CREATED]
          ,[UPDATED]
          ,[CREATEDBY]
          ,[UPDATEDBY]
          ,[LOOKUP_LIST_CATEGORY]
          ,[BASE_CONTROL_WIDTH]
          ,[DATA_ELEMENT_WIDTH]
          ,[REQUIRED]
          ,[INCLUDE_LABEL]
          ,[LABEL_TEXT]
          ,[LOOKUP_LIST_CATEGORY2]
          ,[LOOKUP_LIST_CATEGORY3]
          ,[VALIDATION_GROUP]
          ,[DATA_TYPE_MAX_LENGTH]
          ,[PANEL_NAME]
          )
SELECT [STD_REGISTRY_ID]
      ,[CATEGORY]
      ,[NAME]
      ,[BASE_CONTROL_TYPE]
      ,[USER_CONTROL_ID]
      ,[VALIDATION_ERROR_MESSAGE]
      ,[VALIDATION_REGULAR_EXPRESSION]
      ,[TOOL_TIP]
      ,[SORT_ORDER]
      ,[CREATED]
      ,[UPDATED]
      ,[CREATEDBY]
      ,[UPDATEDBY]
      ,[LOOKUP_LIST_CATEGORY]
      ,[BASE_CONTROL_WIDTH]
      ,[DATA_ELEMENT_WIDTH]
      ,[REQUIRED]
      ,[INCLUDE_LABEL]
      ,[LABEL_TEXT]
      ,[LOOKUP_LIST_CATEGORY2]
      ,[LOOKUP_LIST_CATEGORY3]
      ,[VALIDATION_GROUP]
      ,[DATA_TYPE_MAX_LENGTH]
      ,[PANEL_NAME]
  FROM [AHOBPR].[std_gui_controls_pre2_0_24_1];

  drop table ahobpr.std_gui_controls_pre2_0_24_1;
end;


go

print N'Rollback complete.';
GO

delete 
  from [dbo].[DatabaseChangeLog]
  where [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    and [PointReleaseNumber] = '$(PointReleaseNumber)'
    and [ScriptName]         = '$(ScriptName)';
GO
------------------------------------------
-- 2.0.23.1
------------------------------------------
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "23"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.23.1.sql"

print ' 
------------------------------------------------------------------------------------------------
Rollback $(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
print 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
print ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
go
:on error exit
go
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
set noexec off; 
go
if N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        print N'SQLCMD mode must be enabled to successfully execute this script.';
        set NOEXEC ON; --When set NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    end

go

use [$(DatabaseName)]
GO

--**************
--Rollback steps
--**************
--
update  [dbo].[DatabaseChangeLog]
  set [ScriptDescription] = 'Rollback initiated...'
  where [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    and [PointReleaseNumber] = '$(PointReleaseNumber)'
    and [ScriptName]         = '$(ScriptName)';
go
set ansi_nulls, ansi_padding, ansi_warnings, arithabort, concat_null_yields_null, quoted_identifier on;

set numeric_roundabort off;

go

  update [AHOBPR].[STD_REGISTRY_FLAG_TYPE]
  set REGISTRY_FLAG_TYPE = REPLACE(REGISTRY_FLAG_TYPE, 'Subpopulation', 'SubPopulation'),
	  REGISTRY_FLAG_TYPE_DESCRIPTION = REPLACE(REGISTRY_FLAG_TYPE_DESCRIPTION, 'Subpopulation', 'SubPopulation');


go

print N'Rollback complete.';
GO

delete 
  from [dbo].[DatabaseChangeLog]
  where [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    and [PointReleaseNumber] = '$(PointReleaseNumber)'
    and [ScriptName]         = '$(ScriptName)';
GO
--------------------------------------------
-- 2.0.20.2
--------------------------------------------
--:setvar DatabaseName "Registry"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "20"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.20.2.sql"

print ' 
------------------------------------------------------------------------------------------------
Rollback $(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
print 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
print ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
set noexec off; 
go
if N'$(__IsSqlCmdEnabled)' not like N'True'
begin
    print N'SQLCMD mode must be enabled to successfully execute this script.';
    set noexec on; --when set noexec is on, sql server compiles each batch of transact-sql statements but does not execute them.
end

GO

USE [$(DatabaseName)]
GO
------------------------------------------
------------------------------------------
if exists (select * from sys.triggers where object_id = OBJECT_ID(N'[AHOBPR].[TRG_AHOBPR_USER_H]'))
  drop trigger [AHOBPR].[TRG_AHOBPR_USER_H];
go

if exists(select * from sys.triggers where object_id=OBJECT_ID(N'[AHOBPR].[TRG_AHOBPR_USER_DEL_H]'))
  drop trigger [AHOBPR].[TRG_AHOBPR_USER_DEL_H];
go
if exists (select * from sys.objects where object_id = OBJECT_ID(N'[AHOBPR].[AHOBPR_USER_H]') AND type in (N'U'))
begin
  drop table [AHOBPR].[AHOBPR_USER_H];
end;
go

if exists (select * from sys.triggers where object_id = OBJECT_ID(N'[AHOBPR].[TRG_EMAIL_TEMPLATES_H]'))
  drop trigger [AHOBPR].[TRG_EMAIL_TEMPLATES_H];
go

if exists(select * from sys.triggers where object_id=OBJECT_ID(N'[AHOBPR].[TRG_EMAIL_TEMPLATES_DEL_H]'))
  drop trigger [AHOBPR].[TRG_EMAIL_TEMPLATES_DEL_H];
go

if exists (select * from sys.objects where object_id = OBJECT_ID(N'[AHOBPR].[EMAIL_TEMPLATES_H]') AND type in (N'U'))
begin
  drop table [AHOBPR].[EMAIL_TEMPLATES_H]
end;
go

if exists (select * from sys.triggers where object_id = OBJECT_ID(N'[AHOBPR].[TRG_FOLLOWUP_FORM_RESPONSE_H]'))
  drop trigger [AHOBPR].[TRG_FOLLOWUP_FORM_RESPONSE_H];
go
if exists(select * from sys.triggers where object_id=OBJECT_ID(N'[AHOBPR].[TRG_FOLLOWUP_FORM_RESPONSE_DEL_H]'))
  drop trigger [AHOBPR].[TRG_FOLLOWUP_FORM_RESPONSE_DEL_H];
go

if exists (select * from sys.objects where object_id = OBJECT_ID(N'[AHOBPR].[FOLLOWUP_FORM_RESPONSE_H]') AND type in (N'U'))
begin
  drop table [AHOBPR].[FOLLOWUP_FORM_RESPONSE_H];
end;
go
if exists (select * from sys.triggers where object_id = OBJECT_ID(N'[AHOBPR].[TRG_FOLLOWUP_FORM_RESPONSE_ANSWER_H]'))
  drop trigger [AHOBPR].[TRG_FOLLOWUP_FORM_RESPONSE_ANSWER_H];
go
if exists(select * from sys.triggers where object_id=OBJECT_ID(N'[AHOBPR].[TRG_FOLLOWUP_FORM_RESPONSE_ANSWER_DEL_H]'))
  drop trigger [AHOBPR].[TRG_FOLLOWUP_FORM_RESPONSE_ANSWER_DEL_H];
go

if exists (select * from sys.objects where object_id = OBJECT_ID(N'[AHOBPR].[FOLLOWUP_FORM_RESPONSE_ANSWER_H]') AND type in (N'U'))
begin
  drop table [AHOBPR].[FOLLOWUP_FORM_RESPONSE_ANSWER_H];
end;
go
if exists (select * from sys.triggers where object_id = OBJECT_ID(N'[AHOBPR].[TRG_FOLLOWUP_FORM_RESPONSE_QUESTION_H]'))
  drop trigger [AHOBPR].[TRG_FOLLOWUP_FORM_RESPONSE_QUESTION_H];
go
if exists(select * from sys.triggers where object_id=OBJECT_ID(N'[AHOBPR].[TRG_FOLLOWUP_FORM_RESPONSE_QUESTION_DEL_H]'))
  drop trigger [AHOBPR].[TRG_FOLLOWUP_FORM_RESPONSE_QUESTION_DEL_H];
go

if exists (select * from sys.objects where object_id = OBJECT_ID(N'[AHOBPR].[FOLLOWUP_FORM_RESPONSE_QUESTION_H]') AND type in (N'U'))
begin
  drop table [AHOBPR].[FOLLOWUP_FORM_RESPONSE_QUESTION_H];
end;
go
if exists (select * from sys.triggers where object_id = OBJECT_ID(N'[AHOBPR].[TRG_TOOL_ANSWER_H]'))
  drop trigger [AHOBPR].[TRG_TOOL_ANSWER_H];
go
if exists(select * from sys.triggers where object_id=OBJECT_ID(N'[AHOBPR].[TRG_TOOL_ANSWER_DEL_H]'))
  drop trigger [AHOBPR].[TRG_TOOL_ANSWER_DEL_H];
go

if exists (select * from sys.objects where object_id = OBJECT_ID(N'[AHOBPR].[TOOL_ANSWER_H]') AND type in (N'U'))
begin
  drop table [AHOBPR].[TOOL_ANSWER_H];
end;
go
if exists (select * from sys.triggers where object_id = OBJECT_ID(N'[AHOBPR].[TRG_TOOL_FORM_H]'))
  drop trigger [AHOBPR].[TRG_TOOL_FORM_H];
go
if exists(select * from sys.triggers where object_id=OBJECT_ID(N'[AHOBPR].[TRG_TOOL_FORM_DEL_H]'))
  drop trigger [AHOBPR].[TRG_TOOL_FORM_DEL_H];
go

if exists (select * from sys.objects where object_id = OBJECT_ID(N'[AHOBPR].[TOOL_FORM_H]') AND type in (N'U'))
begin
  drop table [AHOBPR].[TOOL_FORM_H];
end;
go
if exists (select * from sys.triggers where object_id = OBJECT_ID(N'[AHOBPR].[TRG_TOOL_FORM_QUESTION_H]'))
  drop trigger [AHOBPR].[TRG_TOOL_FORM_QUESTION_H]
go
if exists(select * from sys.triggers where object_id=OBJECT_ID(N'[AHOBPR].[TRG_TOOL_FORM_QUESTION_DEL_H]'))
  drop trigger [AHOBPR].[TRG_TOOL_FORM_QUESTION_DEL_H];
go

if exists (select * from sys.objects where object_id = OBJECT_ID(N'[AHOBPR].[TOOL_FORM_QUESTION_H]') AND type in (N'U'))
begin
  drop table [AHOBPR].[TOOL_FORM_QUESTION_H];
end;
go
if exists (select * from sys.triggers where object_id = OBJECT_ID(N'[AHOBPR].[TRG_TOOL_QUESTION_H]'))
drop trigger [AHOBPR].[TRG_TOOL_QUESTION_H]
go

if exists(select * from sys.triggers where object_id=OBJECT_ID(N'[AHOBPR].[TRG_TOOL_QUESTION_DEL_H]'))
  drop trigger [AHOBPR].[TRG_TOOL_QUESTION_DEL_H]
go

if exists (select * from sys.objects where object_id = OBJECT_ID(N'[AHOBPR].[TOOL_QUESTION_H]') AND type in (N'U'))
begin
  drop table [AHOBPR].[TOOL_QUESTION_H]
end;
print N'Rollback complete.';
go

delete 
  from [dbo].[DatabaseChangeLog]
  where [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    and [PointReleaseNumber] = '$(PointReleaseNumber)'
    and [ScriptName]         = '$(ScriptName)';
go


-------------------------------------------------------
-- 2.0.20.1
-------------------------------------------------------
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "20"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.20.1.sql"

print ' 
------------------------------------------------------------------------------------------------
Rollback $(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
print 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
print ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
go
:on error exit
go
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
set noexec off; 
go
if N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        print N'SQLCMD mode must be enabled to successfully execute this script.';
        set NOEXEC ON; --When set NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    end

go

use [$(DatabaseName)]
GO

--**************
--Rollback steps
--**************
--
update  [dbo].[DatabaseChangeLog]
  set [ScriptDescription] = 'Rollback initiated...'
  where [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    and [PointReleaseNumber] = '$(PointReleaseNumber)'
    and [ScriptName]         = '$(ScriptName)';
go
set ansi_nulls, ansi_padding, ansi_warnings, arithabort, concat_null_yields_null, quoted_identifier on;

set numeric_roundabort off;

go

if exists (select * from sys.procedures where name = 'SP_GetRegistrantFile'
          and schema_id = (select schema_id from [sys].[schemas] where name = 'AHOBPR') 
          )
begin
  print 'Drop procedure SP_GetRegistrantFile...';
  drop procedure ahobpr.SP_GetRegistrantFile;
end;

go

print N'Rollback complete.';
GO

delete 
  from [dbo].[DatabaseChangeLog]
  where [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    and [PointReleaseNumber] = '$(PointReleaseNumber)'
    and [ScriptName]         = '$(ScriptName)';
GO
-----------------------------------------
-- 2.0.17.1
------------------------------------------

--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "17"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.17.1.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
Rollback $(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
SET NOEXEC OFF; 
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO

USE [$(DatabaseName)]
GO

--**************
--Rollback steps
--**************
--
UPDATE  [dbo].[DatabaseChangeLog]
  SET [ScriptDescription] = 'Rollback initiated...'
  WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber] = '$(PointReleaseNumber)'
    AND [ScriptName]         = '$(ScriptName)';
GO
SET ANSI_NULLS, ANSI_PADDING, ANSI_WARNINGS, ARITHABORT, CONCAT_NULL_YIELDS_NULL, QUOTED_IDENTIFIER ON;

SET NUMERIC_ROUNDABORT OFF;

GO

if exists (select * from sys.procedures where name = 'SP_GetRegistrantAddFlag_Pre2_0_17'
          and schema_id = (select schema_id from [sys].[schemas] where name = 'AHOBPR') 
          )
begin
  print 'Move AHOBPR.SP_GetRegistrantAddFlag_Pre2_0_17 to SP_GetRegistrantAddFlag...';
  if exists (select * from sys.procedures where name = 'SP_GetRegistrantAddFlag'
              and schema_id = (select schema_id from [sys].[schemas] where name = 'AHOBPR') 
            )
    drop procedure ahobpr.SP_GetRegistrantAddFlag;
  exec sp_rename 'AHOBPR.SP_GetRegistrantAddFlag_Pre2_0_17', 'SP_GetRegistrantAddFlag';
end;

go
if exists (select * from sys.procedures where name = 'SP_GetRegistrantSendQuestions_Pre2_0_17'
           and schema_id = (select schema_id from [sys].[schemas] where name = 'AHOBPR') 
           )
begin
  print 'Move AHOBPR.SP_GetRegistrantSendQuestions_Pre2_0_17 to SP_GetRegistrantSendQuestions...';
  if exists (select * from sys.procedures where name = 'SP_GetRegistrantSendQuestions'
              and schema_id = (select schema_id from [sys].[schemas] where name = 'AHOBPR') 
            )
    drop procedure ahobpr.SP_GetRegistrantSendQuestions;
  exec sp_rename 'AHOBPR.SP_GetRegistrantSendQuestions_Pre2_0_17', 'SP_GetRegistrantSendQuestions';
end;

GO
IF exists (select * from sys.views where name='view_lookup_Pre2_0_17_1'
           and schema_id = (select schema_id from sys.schemas where name = 'ahobpr')
          )
begin
  print 'Move VIEW_LOOKUP2_0_17_1 to VIEW_LOOKUP_Pre';
  if exists (select * from sys.views where name = 'VIEW_LOOKUP'
              and schema_id = (select schema_id from sys.schemas where name = 'ahobpr')
            )
    drop view ahobpr.view_lookup;
  exec sp_rename 'AHOBPR.VIEW_LOOKUP_Pre2_0_17_1', 'VIEW_LOOKUP';
end;
go
PRINT N'Rollback complete.';
GO

DELETE 
  FROM [dbo].[DatabaseChangeLog]
  WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber] = '$(PointReleaseNumber)'
    AND [ScriptName]         = '$(ScriptName)';
GO
-------------------------------------------
---- 2.0.16.1
-------------------------------------------
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "16"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.16.1.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
Rollback $(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
SET NOEXEC OFF; 
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO

USE [$(DatabaseName)]
GO

--**************
--Rollback steps
--**************
--
UPDATE  [dbo].[DatabaseChangeLog]
  SET [ScriptDescription] = 'Rollback initiated...'
  WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber] = '$(PointReleaseNumber)'
    AND [ScriptName]         = '$(ScriptName)';
go
set ansi_nulls, ansi_padding, ansi_warnings, arithabort, concat_null_yields_null, quoted_identifier on;

set numeric_roundabort off;

go

if exists (select * from sys.procedures where name = 'SP_ReportAdHocByIndividual_Pre2_0_16_1'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR') )
begin
  if exists (select * from sys.procedures where name = 'SP_ReportAdHocByIndividual'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR') )
    drop procedure ahobpr.SP_ReportAdHocByIndividual;
  exec sp_rename 'ahobpr.SP_ReportAdHocByIndividual_Pre2_0_16_1', 'SP_ReportAdHocByIndividual';
end;
go

if exists (select * from sys.procedures where name = 'SP_ReportRegistrantContact_Pre2_0_16_1'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR') )
begin
  if exists (select * from sys.procedures where name = 'SP_ReportRegistrantContact'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR') )
    drop procedure ahobpr.SP_ReportRegistrantContact;
  exec sp_rename 'ahobpr.SP_ReportRegistrantContact_Pre2_0_16_1', 'SP_ReportRegistrantContact';
end;
go

IF EXISTS (select * from sys.procedures where name = 'SP_GetRegistrantSendMessage_Pre2_0_16_1'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR') )
BEGIN
  if exists (select * from sys.procedures where name = 'SP_GetRegistrantSendMessage'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR') )
    DROP PROCEDURE ahobpr.SP_GetRegistrantSendMessage;
  EXEC sp_rename 'ahobpr.SP_GetRegistrantSendMessage_Pre2_0_16_1', 'SP_GetRegistrantSendMessage';
END;
GO

IF EXISTS (select * from sys.procedures where name = 'SP_ReportAdHocByLocation_Pre2_0_16_1'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR') )
BEGIN
  if exists (select * from sys.procedures where name = 'SP_ReportAdHocByLocation'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR') )
    DROP PROCEDURE ahobpr.SP_ReportAdHocByLocation;
  EXEC sp_rename 'ahobpr.SP_ReportAdHocByLocation_Pre2_0_16_1', 'SP_ReportAdHocByLocation';
END;

GO
PRINT N'Rollback complete.';
GO

DELETE 
  FROM [dbo].[DatabaseChangeLog]
  WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber] = '$(PointReleaseNumber)'
    AND [ScriptName]         = '$(ScriptName)';
GO
-- nothing to do for 2.0.15.1
DELETE 
  FROM [dbo].[DatabaseChangeLog]
  WHERE [MajorReleaseNumber] = '2'
    AND [MinorReleaseNumber] = '0'
    AND [PointReleaseNumber] = '15';
go
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "14"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.14.1.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
Rollback $(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
SET NOEXEC OFF; 
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO

USE [$(DatabaseName)]
GO

--**************
--Rollback steps
--**************
--
UPDATE  [dbo].[DatabaseChangeLog]
  SET [ScriptDescription] = 'Rollback initiated...'
  WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber] = '$(PointReleaseNumber)'
    AND [ScriptName]         = '$(ScriptName)';
GO
SET ANSI_NULLS, ANSI_PADDING, ANSI_WARNINGS, ARITHABORT, CONCAT_NULL_YIELDS_NULL, QUOTED_IDENTIFIER ON;

SET NUMERIC_ROUNDABORT OFF;

GO
IF EXISTS (select * from sys.procedures where name = 'sp_DeleteOneRegistrant_PriorTo2_0_14'
            and schema_id = (select SCHEMA_ID from sys.schemas where name = 'AHOBPR')
          )
BEGIN
  if exists (select * from sys.procedures where name = 'SP_DeleteOneRegistrant'
              and schema_id = (select SCHEMA_ID from sys.schemas where name = 'AHOBPR')
            )
    DROP PROCEDURE AHOBPR.SP_DeleteOneRegistrant;
  EXEC sp_RENAME 'AHOBPR.SP_DeleteOneRegistrant_PriorTo2_0_14', 'sp_DeleteOneRegistrant';
END;
  

IF EXISTS (select * from sys.procedures where name = 'SP_DeleteRegistrantAndResponse_PriorTo2_0_14'
            and schema_id = (select SCHEMA_ID from sys.schemas where name = 'AHOBPR')
          )
BEGIN
  if exists (select * from sys.procedures where name = 'SP_DeleteRegistrantAndResponse'
              and schema_id = (select SCHEMA_ID from sys.schemas where name = 'AHOBPR')
            )
    DROP PROCEDURE AHOBPR.SP_DeleteRegistrantAndResponse;
  EXEC sp_RENAME 'AHOBPR.SP_DeleteRegistrantAndResponse_PriorTo2_0_14', 'SP_DeleteRegistrantAndResponse';
END;
  
GO
PRINT N'Rollback complete.';
GO

DELETE 
  FROM [dbo].[DatabaseChangeLog]
  WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber] = '$(PointReleaseNumber)'
    AND [ScriptName]         = '$(ScriptName)';
GO
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "13"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.13.1.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
Rollback $(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
SET NOEXEC OFF; 
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOCOUNT ON;
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO

USE [$(DatabaseName)]
GO

--**************
--Rollback steps
--**************
--
if exists (select * from sys.views where name = 'view_lookup_pre_2_0_13_1'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
begin
  if exists (select * from sys.views where name = 'VIEW_LOOKUP'
               and  schema_id = (select schema_id from sys.schemas where name = 'AHOBPR'))
    drop view AHOBPR.VIEW_LOOKUP;
  exec sp_rename 'ahobpr.view_lookup_pre_2_0_13_1', 'VIEW_LOOKUP';
end;

if exists(select * from sys.columns where name = 'SALUTATION'
            and object_id = (select object_id from sys.tables where name = 'EMAIL_TEMPLATES'
                              and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                            )
         )
begin
  if exists(select * from sys.default_constraints where name = 'DF_EmailTemplates_Salutation'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
      alter table [AHOBPR].[EMAIL_TEMPLATES]
        drop constraint DF_EmailTemplates_Salutation;
  alter table [AHOBPR].[EMAIL_TEMPLATES]
    drop column SALUTATION;
end;
if exists(select * from sys.columns where name = 'CONTACT_INFO'
            and object_id = (select object_id from sys.tables where name = 'EMAIL_TEMPLATES'
                              and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                            )
         )
begin
  if exists(select * from sys.default_constraints where name = 'DF_EmailTemplates_ContactInfo'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
      alter table [AHOBPR].[EMAIL_TEMPLATES]
        drop constraint DF_EmailTemplates_ContactInfo;
  alter table [AHOBPR].[EMAIL_TEMPLATES]
    drop column CONTACT_INFO;
end;
if exists(select * from sys.columns where name = 'ADVANCED_USER_FLAG'
            and object_id = (select object_id from sys.tables where name = 'EMAIL_TEMPLATES'
                              and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                            )
         )
begin
    if exists(select * from sys.default_constraints where name = 'DF_EmailTemplates_AdvancedUserFlag'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
      alter table [AHOBPR].[EMAIL_TEMPLATES]
        drop constraint DF_EmailTemplates_AdvancedUserFlag;
  alter table [AHOBPR].[EMAIL_TEMPLATES]
    drop column ADVANCED_USER_FLAG;
end;
if exists(select * from sys.columns where name = 'CREATEDBY_ADVANCED_USER_FLAG'
            and object_id = (select object_id from sys.tables where name = 'EMAIL_TEMPLATES'
                              and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                            )
         )
begin
  if exists(select * from sys.default_constraints where name = 'DF_EmailTemplates_CreatedbyAdvanceduserFlag'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
    alter table [AHOBPR].[EMAIL_TEMPLATES]
      drop constraint DF_EmailTemplates_CreatedbyAdvanceduserFlag;
  alter table [AHOBPR].[EMAIL_TEMPLATES]
    drop column CREATEDBY_ADVANCED_USER_FLAG;
end;
GO
PRINT N'2.0.13.1 Rollback complete.';

go
delete 
--select *
  from [dbo].[DatabaseChangeLog]
  where [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    and [PointReleaseNumber] = '$(PointReleaseNumber)'
    and [ScriptName]         = '$(ScriptName)';
go
-------------------------------------------
-------------------------------------------
---- 2.0.12.1
-------------------------------------------
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "12"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.12.1.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
Rollback $(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
SET NOEXEC OFF; 
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOCOUNT ON;
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO

USE [$(DatabaseName)]
GO

--**************
--Rollback steps
--**************
--

UPDATE  [dbo].[DatabaseChangeLog]
  SET [ScriptDescription] = 'Rollback initiated...'
  WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber] = '$(PointReleaseNumber)'
    AND [ScriptName]         = '$(ScriptName)';
GO
IF EXISTS (select * from sys.procedures where name = 'SP_GetRegistrantAddFlag'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
  DROP PROCEDURE AHOBPR.SP_GetRegistrantAddFlag;
GO
PRINT N'Rollback complete.';
GO

DELETE 
  FROM [dbo].[DatabaseChangeLog]
  WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber] = '$(PointReleaseNumber)'
    AND [ScriptName]         = '$(ScriptName)';
GO
-------------------------------------------
-------------------------------------------
-- 2.0.11.1
-------------------------------------------
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "11"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.11.1.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
Rollback $(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
SET NOEXEC OFF; 
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO

USE [$(DatabaseName)]
GO

--**************
--Rollback steps
--**************
--
UPDATE  [dbo].[DatabaseChangeLog]
  SET [ScriptDescription] = 'Rollback initiatited...'
  WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber] = '$(PointReleaseNumber)'
    AND [ScriptName]         = '$(ScriptName)';
GO
GO
SET ANSI_NULLS, ANSI_PADDING, ANSI_WARNINGS, ARITHABORT, CONCAT_NULL_YIELDS_NULL, QUOTED_IDENTIFIER ON;

SET NUMERIC_ROUNDABORT OFF;


GO
USE [$(DatabaseName)];


GO
IF EXISTS (select * from sys.columns where name = 'STANDARD_FLAG'
            and object_id = (select object_id from sys.objects where name = 'TOOL_ANSWER'
                                and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                              )
          )
begin
  alter table [AHOBPR].[TOOL_ANSWER]
    drop constraint DF_ToolAnswer_StandardFlag;
  ALTER TABLE [AHOBPR].[TOOL_ANSWER]
	  DROP COLUMN STANDARD_FLAG;
end;
GO

DELETE 
  FROM [dbo].[DatabaseChangeLog]
  WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber] = '$(PointReleaseNumber)'
    AND [ScriptName]         = '$(ScriptName)';

go
-------------------------------------------
---- 2.0.9.2
-------------------------------------------
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "9"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.9.2.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
Rollback $(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
SET NOEXEC OFF; 
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO

USE [$(DatabaseName)]
GO

--**************
--Rollback steps
--**************
--
UPDATE  [dbo].[DatabaseChangeLog]
  SET [ScriptDescription] = 'Rollback initiated...'
  WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber] = '$(PointReleaseNumber)'
    AND [ScriptName]         = '$(ScriptName)';
GO
SET ANSI_NULLS, ANSI_PADDING, ANSI_WARNINGS, ARITHABORT, CONCAT_NULL_YIELDS_NULL, QUOTED_IDENTIFIER ON;

SET NUMERIC_ROUNDABORT OFF;

GO

IF EXISTS (select * from sys.procedures where name = 'SP_GetRegistrantSendQuestions_temp'
           AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
BEGIN
    PRINT 'DROP PROCEDURE [AHOBPR].[SP_GetRegistrantSendQuestions_temp]';
    DROP PROCEDURE [AHOBPR].[SP_GetRegistrantSendQuestions_temp];
END;

GO
IF EXISTS (select * from sys.tables where name = 'SP_GetScriptsBatch'
           AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
BEGIN 
  PRINT N'Dropping [AHOBPR].[SP_GetScriptsBatch]...';
  DROP PROCEDURE [AHOBPR].[SP_GetScriptsBatch];
END;

GO
IF EXISTS (select * from sys.procedures where name = 'SP_UpdateScriptsBatchStatus'
           AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
BEGIN 
  PRINT N'Dropping [AHOBPR].[SP_UpdateScriptsBatchStatus]...';
  DROP PROCEDURE [AHOBPR].[SP_UpdateScriptsBatchStatus];
END;

GO


IF EXISTS (select * from sys.tables where name = 'SCRIPTS_BATCH'
           AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
BEGIN 
  PRINT N'Dropping [AHOBPR].[SCRIPTS_BATCH]...';
  DROP TABLE [AHOBPR].[SCRIPTS_BATCH];
END;


GO

--PRINT N'Altering [AHOBPR].[VIEW_LOOKUP]...';
--if exists (select * from sys.views where name = 'VIEW_LOOKUP'
--            and schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
--          )
--  drop view [AHOBPR].[VIEW_LOOKUP];
--GO

--CREATE VIEW [AHOBPR].[VIEW_LOOKUP] 
--WITH SCHEMABINDING 
--AS
--  SELECT 'REGISTRY_FLAG' AS LOOKUP_TYPE  
--	       ,STD_REGISTRY_FLAG_ID AS ID
--         ,REGISTRY_FLAG_NAME AS CODE
--         ,REGISTRY_FLAG_NAME AS NAME
--         ,0 AS PARENT_ID
--         ,1 AS SORT_ORDER
--    FROM AHOBPR.STD_REGISTRY_FLAG
--   WHERE STD_REGISTRY_FLAG_ID > 0
--  UNION ALL
--  SELECT 'REGISTRY_STATUS' AS LOOKUP_TYPE  
--	     ,STD_REGISTRANT_STATUS_ID AS ID
--         ,REGISTRANT_STATUS AS CODE
--         ,REGISTRANT_STATUS AS NAME
--         ,0 AS PARENT_ID
--         ,ORDINAL_VALUE AS SORT_ORDER
--    FROM AHOBPR.STD_REGISTRANT_STATUS
--   WHERE STD_REGISTRANT_STATUS_ID > 0
--  UNION ALL
--  SELECT 'REGISTRY_FLAG_TYPE' AS LOOKUP_TYPE  
--	     ,STD_REGISTRY_FLAG_TYPE_ID AS ID
--         ,REGISTRY_FLAG_TYPE AS CODE
--         ,REGISTRY_FLAG_TYPE AS NAME
--         ,0 AS PARENT_ID
--         ,1 AS SORT_ORDER
--    FROM AHOBPR.STD_REGISTRY_FLAG_TYPE
--  UNION ALL
--  SELECT 'SUBPOPULATION_FLAG_ACTIVE' AS LOOKUP_TYPE  
--	     ,STD_REGISTRY_FLAG_ID AS ID
--         ,REGISTRY_FLAG_NAME AS CODE
--         ,REGISTRY_FLAG_NAME AS NAME
--         ,0 AS PARENT_ID
--         ,1 AS SORT_ORDER
--  FROM AHOBPR.STD_REGISTRY_FLAG
--  WHERE ACTIVE_FLAG = 1 AND STD_REGISTRY_FLAG_TYPE_ID = 2
--  UNION ALL
--  SELECT 'STD_STATE' AS LOOKUP_TYPE  
--	     ,ID 
--         ,POSTALNAME AS CODE
--         ,POSTALNAME AS NAME
--         ,0 AS PARENT_ID
--         ,1 AS SORT_ORDER
--  FROM DBO.STD_STATE
--  WHERE COUNTRY_ID = 1006840
--	    AND POSTALNAME IN ('AL', 'AK', 'AR', 'AZ', 'CA', 'CO', 'CT', 'DE', 'FL', 'GA', 'HI', 
--	    'IA', 'ID', 'IL', 'IN', 'KS', 'KY', 'LA', 'MA', 'MD', 'ME', 'MI', 'MN', 'MO', 'MS', 
--	    'MT', 'NC', 'ND', 'NE', 'NH', 'NJ', 'NM', 'NV', 'NY', 'OH', 'OK', 'OR', 'PA', 'RI', 
--	    'SC', 'SD', 'TN', 'TX', 'UT', 'VA', 'VT', 'WA', 'WI', 'WV', 'WY', 'DC', 'AS', 'GU', 'PR', 'VI', 'MP', 'AA', 'AE', 'AP')
--  UNION ALL
--  SELECT 'STD_STATE' AS LOOKUP_TYPE  
--	     ,0 
--         ,'Foreign Country/Other' AS CODE
--         ,'Foreign Country/Other' AS NAME
--         ,0 AS PARENT_ID
--         ,9999 AS SORT_ORDER 
--  UNION ALL
--  SELECT 'ADMINTRACKING_FLAG_ACTIVE' AS LOOKUP_TYPE  
--	     ,STD_REGISTRY_FLAG_ID AS ID
--         ,REGISTRY_FLAG_NAME AS CODE
--         ,REGISTRY_FLAG_NAME AS NAME
--         ,0 AS PARENT_ID
--         ,1 AS SORT_ORDER
--  FROM AHOBPR.STD_REGISTRY_FLAG
--  WHERE ACTIVE_FLAG = 1
--    AND STD_REGISTRY_FLAG_TYPE_ID = 1 
--    AND (PREDEFINED = 0 
--     OR (PREDEFINED = 1 AND REGISTRY_FLAG_NAME NOT LIKE 'Status Change: %'))
--  UNION ALL
--  SELECT 'STD_SERVICE_STATUS' AS LOOKUP_TYPE  
--	     ,STD_SERVICE_STATUS_ID As ID
--         ,SERVICE_STATUS AS CODE
--         ,SERVICE_STATUS AS NAME
--         ,0 AS PARENT_ID
--         ,1 AS SORT_ORDER
--    FROM AHOBPR.STD_SERVICE_STATUS
--   WHERE STD_SERVICE_STATUS_ID > 0
--    UNION ALL
--  SELECT 'STD_FORM_QUESTION' AS LOOKUP_TYPE  
--	       ,STD_FORM_QUESTION_ID As ID
--         ,FORM_QUESTION_UNIQUE_ID AS CODE
--         ,FORM_QUESTION_UNIQUE_ID AS NAME
--         ,0 AS PARENT_ID
--         ,1 AS SORT_ORDER
--    FROM AHOBPR.STD_FORM_QUESTION
--  UNION ALL
--  SELECT 'REGISTRY_STATUS_INELIGIBLE' AS LOOKUP_TYPE  
--	     ,STD_REGISTRANT_STATUS_ID AS ID
--         ,REGISTRANT_STATUS AS CODE
--         ,REGISTRANT_STATUS AS NAME
--         ,0 AS PARENT_ID
--         ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
--    FROM AHOBPR.STD_REGISTRANT_STATUS
--    WHERE STD_REGISTRANT_STATUS_ID IN (3, 4, 5)
--  UNION ALL
--  SELECT 'REGISTRY_STATUS_REVIEWED' AS LOOKUP_TYPE  
--	     ,STD_REGISTRANT_STATUS_ID AS ID
--         ,REGISTRANT_STATUS AS CODE
--         ,REGISTRANT_STATUS AS NAME
--         ,0 AS PARENT_ID
--         ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
--    FROM AHOBPR.STD_REGISTRANT_STATUS
--    WHERE STD_REGISTRANT_STATUS_ID IN (5, 8)
--  UNION ALL
--  SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
--	       ,1 AS ID
--         ,'All' AS CODE
--         ,'All' AS NAME
--         ,0 AS PARENT_ID
--         ,1 AS SORT_ORDER
--  UNION ALL
--  SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
--	       ,2 AS ID
--         ,'Facility' AS CODE
--         ,'Facility' AS NAME
--         ,0 AS PARENT_ID
--         ,2 AS SORT_ORDER
--  UNION ALL
--  SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
--	       ,3 AS ID
--         ,'VISN' AS CODE
--         ,'VISN' AS NAME
--         ,0 AS PARENT_ID
--         ,3 AS SORT_ORDER
--  UNION ALL
--  SELECT 'SUBPOPULATION_FLAG_ALL' AS LOOKUP_TYPE  
--	       ,STD_REGISTRY_FLAG_ID AS ID
--         ,REGISTRY_FLAG_NAME AS CODE
--         ,REGISTRY_FLAG_NAME AS NAME
--         ,0 AS PARENT_ID
--         ,1 AS SORT_ORDER
--  FROM AHOBPR.STD_REGISTRY_FLAG
--  WHERE STD_REGISTRY_FLAG_TYPE_ID = 2
--  UNION ALL
--  SELECT 'ADMIN_FLAG_ALL' AS LOOKUP_TYPE  
--	       ,STD_REGISTRY_FLAG_ID AS ID
--         ,REGISTRY_FLAG_NAME AS CODE
--         ,REGISTRY_FLAG_NAME AS NAME
--         ,0 AS PARENT_ID
--         ,1 AS SORT_ORDER
--  FROM AHOBPR.STD_REGISTRY_FLAG
--  WHERE STD_REGISTRY_FLAG_TYPE_ID = 1
--  UNION ALL
--  SELECT 'HEALTH_FACTOR' AS LOOKUP_TYPE
--	       ,A.[STD_HEALTH_FACTOR_ID] AS ID
--         ,A.[NAME] AS CODE
--         ,B.[DESCRIPTION] + ': ' + A.DESCRIPTION AS NAME
--         ,0 AS PARENT_ID
--         ,1 AS SORT_ORDER
--    FROM [AHOBPR].[STD_HEALTH_FACTOR] A INNER JOIN [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY] B ON A.STD_HEALTH_FACTOR_CATEGORY_ID = B.STD_HEALTH_FACTOR_CATEGORY_ID
--  UNION ALL
--  SELECT DISTINCT 'DEPLOYMENT_COUNTRY' AS LOOKUP_TYPE
--	       ,0 AS ID
--         ,[DEPLOYMENT_COUNTRY] AS CODE
--         ,[DEPLOYMENT_COUNTRY] AS NAME
--         ,0 AS PARENT_ID
--         ,1 AS SORT_ORDER
--    FROM [AHOBPR].[REGISTRANT_DEPLOYMENT]
--  UNION ALL
--  SELECT DISTINCT 'DEPLOYMENT_COUNTRY_EXPOSURE' AS LOOKUP_TYPE
--	       ,0 AS ID
--         ,[DEPLOYMENT_COUNTRY] AS CODE
--         ,[DEPLOYMENT_COUNTRY] AS NAME
--         ,0 AS PARENT_ID
--         ,1 AS SORT_ORDER
--    FROM [AHOBPR].[REGISTRANT_DEPLOYMENT] A JOIN AHOBPR.FORM_RESPONSE_QUESTION B
--	  ON A.REGISTRANT_DEPLOYMENT_ID = B.REGISTRANT_DEPLOYMENT_ID
--	  UNION ALL
--  SELECT 'STD_RACE' AS LOOKUP_TYPE 
--	       ,ID
--         ,DESCRIPTION AS CODE
--         ,DESCRIPTION AS NAME
--         ,0 AS PARENT_ID
--         ,1 AS SORT_ORDER
--  FROM AHOBPR.VIEW_ETL_LOOKUP
--  WHERE TYPE = 'STD_RACE'
--    AND ID > 0
--  UNION ALL
--  SELECT 'STD_GENDER' AS LOOKUP_TYPE 
--	       ,ID
--         ,DESCRIPTION AS CODE
--         ,DESCRIPTION AS NAME
--         ,0 AS PARENT_ID
--         ,1 AS SORT_ORDER
--  FROM AHOBPR.VIEW_ETL_LOOKUP
--  WHERE TYPE = 'STD_GENDER'
--    AND ID > 0
--  UNION ALL
--  SELECT 'STD_SEPARATIONFAMILY' AS LOOKUP_TYPE 
--          ,[STD_SEPARATION_FAMILY_ID] AS ID
--          ,[FAMILY_CODE] AS CODE
--          ,[FAMILY]  AS NAME
--          ,0 AS PARENT_ID
--          ,1 AS SORT_ORDER
--     FROM AHOBPR.STD_SEPARATION_FAMILY
--    WHERE  [STD_SEPARATION_FAMILY_ID] > 0
--   UNION ALL  
--   SELECT 'STD_SEPARATIONREASON' AS LOOKUP_TYPE 
--          ,[STD_SEPARATION_REASON_ID] AS ID
--          ,[REASON_CODE] AS CODE
--          ,[REASON] AS NAME
--          ,0 AS PARENT_ID
--          ,1 AS SORT_ORDER
--     FROM AHOBPR.STD_SEPARATION_REASON
--    WHERE  [STD_SEPARATION_REASON_ID] > 0
--  UNION ALL
--  SELECT 'STD_ELIGIBLITYSTATUS' AS LOOKUP_TYPE 
--	       ,ID
--         ,DESCRIPTION AS CODE
--         ,DESCRIPTION AS NAME
--         ,0 AS PARENT_ID
--         ,1 AS SORT_ORDER
--  FROM AHOBPR.VIEW_ETL_LOOKUP
--  WHERE TYPE = 'STD_ELIGIBLITYSTATUS'
--    AND ID > 0
--  UNION ALL
--  SELECT 'STD_ETHNICITY' AS LOOKUP_TYPE 
--	       ,ID
--         ,DESCRIPTION AS CODE
--         ,DESCRIPTION AS NAME
--         ,0 AS PARENT_ID
--         ,1 AS SORT_ORDER
--  FROM AHOBPR.VIEW_ETL_LOOKUP
--  WHERE TYPE = 'STD_ETHNICITY'
--    AND ID > 0
--  UNION ALL 
--   SELECT 'STD_CHARACTEROFSERVICE' AS LOOKUP_TYPE  
--	       ,STD_DISCHARGE_CHARACTER_ID As ID
--         ,DISCHARGE_CHARACTER_CODE AS CODE
--         ,DISCHARGE_CHARACTER AS NAME
--         ,0 AS PARENT_ID
--         ,1 AS SORT_ORDER
--    FROM AHOBPR.STD_DISCHARGE_CHARACTER
--  UNION ALL
--  SELECT 'TEMPLATE_MESSAGE_TITLE' AS LOOKUP_TYPE  
--	     ,TEMPLATE_ID AS ID
--         ,TITLE AS CODE
--         ,TITLE AS NAME
--         ,0 AS PARENT_ID
--         ,1 AS SORT_ORDER
--    FROM AHOBPR.EMAIL_TEMPLATES
--  UNION ALL 
--   SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
--	       ,2 As ID,'multipleChoice' AS CODE,'Dropdown List - Mutiple Choice' AS NAME,0 AS PARENT_ID,1 AS SORT_ORDER
--  UNION ALL
--   SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
--	       ,1 As ID,'multiSelect' AS CODE,'Checkboxes - Mutliple Select' AS NAME,0 AS PARENT_ID,2 AS SORT_ORDER
--  UNION ALL 
--   SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
--	       ,3 As ID,'text' AS CODE,'Radio Buttons with Free Text' AS NAME,0 AS PARENT_ID,3 AS SORT_ORDER
--  UNION ALL 
--   SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
--	       ,4 As ID,'number' AS CODE,'Radio Buttons with Numeric Value' AS NAME,0 AS PARENT_ID,4 AS SORT_ORDER
--  UNION ALL
--  SELECT 'FOLLOWUP_QUESTION_GROUP_LIST' AS LOOKUP_TYPE  
--	     ,STD_FORM_ID AS ID
--         ,NAME AS CODE
--         ,NAME AS NAME
--         ,0 AS PARENT_ID
--         ,1 AS SORT_ORDER
--    FROM AHOBPR.STD_FORM
--    WHERE FOLLOWUP_FLAG = 1;
---- select * from  [AHOBPR].[VIEW_LOOKUP]
GO
PRINT N'Altering [AHOBPR].[SP_DeleteOneRegistrant]...';


GO


ALTER PROCEDURE [AHOBPR].[SP_DeleteOneRegistrant]
	@firstName  VARCHAR(50),
	@lastName  VARCHAR(50)
AS

DECLARE @registrantId int, @userId varchar(256)
BEGIN
	SELECT @registrantId = REGISTRANT_ID, @userId = USER_ID FROM [AHOBPR].[REGISTRANT] WHERE FIRST_NAME = @firstName AND LAST_NAME = @lastName
	
	DELETE FROM [AHOBPR].[REGISTRANT_JSON] WHERE OBJECT_ID = @userId

	DELETE FROM [AHOBPR].[REGISTRANT_JSON_FOLLOWUP] WHERE OBJECT_ID = @userId

	exec ahobpr.SP_DeleteRegistrantAndResponse @registrantId

END
GO
PRINT N'Altering [AHOBPR].[SP_JsonGetCurrent]...';


GO

ALTER PROCEDURE [AHOBPR].[SP_JsonGetCurrent]
@ObjectType VARCHAR(100),
 @ObjectId VARCHAR(256)
AS

BEGIN

DECLARE @CurrentId INT;
        
      -- Get the Most Current JSON ID for the Type and ID
      SELECT @CurrentId = MAX([REGISTRANT_JSON_ID]) 
        FROM [AHOBPR].[REGISTRANT_JSON] WITH (READPAST)
       WHERE [OBJECT_TYPE] = @ObjectType  
         AND [OBJECT_ID] = @ObjectId;
         
      -- Get the record   
      SELECT 
			  REGISTRANT_JSON_ID
			, OBJECT_ID
			, OBJECT_TYPE
			, JSON_DATA
			, CREATEDBY
			, UPDATEDBY
			, CREATED
			, UPDATED
        FROM [AHOBPR].[REGISTRANT_JSON] WITH (NOLOCK)
       WHERE [REGISTRANT_JSON_ID] = @CurrentId;

END
-- EXECUTE AHOBPR.SP_JsonGetCurrent 5187
GO
PRINT N'Altering [AHOBPR].[SP_ReportContactHistory]...';


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: November 12, 2014
-- Description:	Used for the AHOBPR Contact History report  
-- Modification log
-- 2015-07-14 CleggB - changed UpdatedDate and output from Date to DateTime2(0)
ALTER PROCEDURE [AHOBPR].[SP_ReportContactHistory]
	@RegistrantId INT = NULL 
WITH EXECUTE AS OWNER
AS
BEGIN

  DECLARE @RowCount SMALLINT = 0;

  DECLARE @Results TABLE(UpdatedDate        DATETIME2(0)
                         ,[STREET1]         VARCHAR(256)
                         ,[STREET2]         VARCHAR(256)
                         ,[CITY]            VARCHAR(100)
                         ,[STATE]           VARCHAR(100)
                         ,[ZIP]             VARCHAR(15)
                         ,[COUNTRY]         VARCHAR(100) 
                         ,PhoneNumber       VARCHAR(50)
                         ,MobileNumber      VARCHAR(50)
                         ,EMAIL             VARCHAR(256)  );  
                             
  DECLARE  @UpdatedDate    DATETIME2(0)
          ,@MyOrder        INT
          ,@Street1        VARCHAR(256)
          ,@Street2        VARCHAR(256)
          ,@City           VARCHAR(100)
          ,@State          VARCHAR(100)
          ,@Zip            VARCHAR(15)
          ,@Country        VARCHAR(100) 
          ,@PhoneNumber    VARCHAR(50)
          ,@MobileNumber   VARCHAR(50)
          ,@Email          VARCHAR(256);     

  DECLARE  @UpdatedDateOut    DATETIME2(0)
          ,@Street1Out        VARCHAR(256)
          ,@Street2Out        VARCHAR(256)
          ,@CityOut           VARCHAR(100)
          ,@StateOut          VARCHAR(100)
          ,@ZipOut            VARCHAR(15)
          ,@CountryOut        VARCHAR(100) 
          ,@PhoneNumberOut    VARCHAR(50)
          ,@MobileNumberOut   VARCHAR(50)
          ,@EmailOut          VARCHAR(256);                                        

  DECLARE MyCursor CURSOR LOCAL
  FOR
  WITH Addr
  AS (
      SELECT DISTINCT
             [REGISTRANT_ID]
            ,[STREET1]
            ,[STREET2]
            ,[CITY]
            ,[STATE]
            ,[ZIP]
            ,[COUNTRY]
            ,[Audit_Date] AS UpdatedDate
            ,CONVERT(INT,'1') AS MyOrder
        FROM [AHOBPR].[REGISTRANT_ADDRESS_H]
       WHERE [Audit_Type] != 'DELETE'
         AND [REGISTRANT_ID] = @RegistrantId
     )
    ,Phone
    AS (
        SELECT DISTINCT
               [REGISTRANT_ID]
              ,[PHONE_NUMBER] as PhoneNumber
              ,[Audit_Date] AS UpdatedDate
              ,CONVERT(INT,'2') AS MyOrder          
          FROM [AHOBPR].[REGISTRANT_PHONE_H]
         WHERE ISNULL([TYPE],'') != 'Mobile'
           AND [Audit_Type] != 'DELETE'
           AND [REGISTRANT_ID] = @RegistrantId      
        )
    ,Mobile
    AS (
        SELECT DISTINCT
               [REGISTRANT_ID]
              ,[PHONE_NUMBER] AS MobileNumber
              ,[Audit_Date] AS UpdatedDate
              ,CONVERT(INT,'3') AS MyOrder
          FROM [AHOBPR].[REGISTRANT_PHONE_H]
         WHERE [TYPE] = 'Mobile'
           AND [Audit_Type] != 'DELETE'
           AND [REGISTRANT_ID] = @RegistrantId          
        )  
   ,Email
   AS (
       SELECT DISTINCT 
              [REGISTRANT_ID]
             ,[EMAIL]
             ,[Audit_Date] AS UpdatedDate
             ,CONVERT(INT,'4') AS MyOrder          
         FROM [AHOBPR].[REGISTRANT_EMAIL_H]
        WHERE [Audit_Type] != 'DELETE'
          AND [REGISTRANT_ID] = @RegistrantId          
       )
        SELECT Addr.UpdatedDate
              ,Addr.Myorder
              ,[STREET1]
              ,[STREET2]
              ,[CITY]
              ,[STATE]
              ,[ZIP]
              ,[COUNTRY]
              ,NULL AS PhoneNumber
              ,NULL as MobileNumber
              ,NULL as EMAIL
          FROM Addr
       UNION
       SELECT Phone.UpdatedDate
              ,Phone.Myorder
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,PhoneNumber
              ,NULL as MobileNumber
              ,NULL as EMAIL
          FROM Phone
       UNION
       SELECT Mobile.UpdatedDate
              ,Mobile.Myorder
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL AS PhoneNumber
              ,MobileNumber
              ,NULL as EMAIL
          FROM Mobile        
        UNION
        SELECT Email.UpdatedDate
              ,Email.Myorder
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL AS PhoneNumber
              ,NULL AS MobileNumber
              ,Email.EMAIL
          FROM Email          
          ORDER BY UpdatedDate DESC, MyOrder ASC;
          
          
    OPEN MyCursor;
    
    FETCH NEXT FROM MyCursor  -- priming read
     INTO @UpdatedDate
          ,@MyOrder   
          ,@Street1   
          ,@Street2   
          ,@City      
          ,@State     
          ,@Zip       
          ,@Country   
          ,@PhoneNumber
          ,@MobileNumber
          ,@Email;       
    
    SET @UpdatedDateOut = @UpdatedDate;          
     
    WHILE @@FETCH_STATUS = 0 -- Not End of file
      BEGIN
        -- If new date, or nowhere to put data value, Insert into temp and clear Output variables
        IF (@UpdatedDate != @UpdatedDateOut AND @RowCount > 0)
        OR (@MyOrder = 1 AND @Street1Out IS NOT NULL)
        OR (@MyOrder = 2 AND @PhoneNumberOut IS NOT NULL)
        OR (@MyOrder = 3 AND @MobileNumberOut IS NOT NULL)
        OR (@MyOrder = 4 AND @EmailOut IS NOT NULL)
        BEGIN
         INSERT INTO @Results (UpdatedDate
                             ,[STREET1]
                             ,[STREET2]
                             ,[CITY]        
                             ,[STATE]         
                             ,[ZIP]          
                             ,[COUNTRY]        
                             ,PhoneNumber     
                             ,MobileNumber    
                             ,EMAIL  )
                      VALUES(@UpdatedDateOut
                            ,@Street1Out
                            ,@Street2Out
                            ,@CityOut
                            ,@StateOut
                            ,@ZipOut
                            ,@CountryOut
                            ,@PhoneNumberOut
                            ,@MobileNumberOut
                            ,@EmailOut);
                            
         SET @UpdatedDateOut = @UpdatedDate;
         SET @Street1Out = NULL;
         SET @Street2Out = NULL;
         SET @CityOut = NULL;
         SET @StateOut = NULL;
         SET @ZipOut = NULL;
         SET @CountryOut = NULL;
         SET @PhoneNumberOut = NULL;
         SET @MobileNumberOut = NULL;
         SET @EmailOut = NULL;                           
        END
        
        SET @RowCount = @RowCount + 1;
        
        -- Set Address Fields
        IF @MyOrder = 1
           BEGIN
             SET @Street1Out = @Street1;
             SET @Street2Out = @Street2;
             SET @CityOut = @City;
             SET @StateOut = @State;
             SET @ZipOut = @Zip;
             SET @CountryOut = @Country;
           END;
                      
        -- Set Phone Number
        IF @MyOrder = 2   
           SET @PhoneNumberOut = @PhoneNumber;
           
        IF @MyOrder = 3
           SET @MobileNumberOut = @MobileNumber;
           
        IF @MyOrder = 4
           SET @EmailOut = @Email;        
      
        FETCH NEXT FROM MyCursor
         INTO @UpdatedDate
              ,@MyOrder   
              ,@Street1   
              ,@Street2   
              ,@City      
              ,@State     
              ,@Zip       
              ,@Country   
              ,@PhoneNumber
              ,@MobileNumber
              ,@Email;       
          
      END;  -- End of loop   
      
      --write last record
     INSERT INTO @Results (UpdatedDate
                   ,[STREET1]
                   ,[STREET2]
                   ,[CITY]        
                   ,[STATE]         
                   ,[ZIP]          
                   ,[COUNTRY]        
                   ,PhoneNumber     
                   ,MobileNumber    
                   ,EMAIL  )
            VALUES(@UpdatedDateOut
                  ,@Street1Out
                  ,@Street2Out
                  ,@CityOut
                  ,@StateOut
                  ,@ZipOut
                  ,@CountryOut
                  ,@PhoneNumberOut
                  ,@MobileNumberOut
                  ,@EmailOut);
    CLOSE MyCursor;
    
    SELECT UpdatedDate
          ,ISNULL(STREET1,'') AS Street1 
          ,ISNULL(STREET2,'') AS Street2
          ,ISNULL(CITY,'') AS City
          ,ISNULL(STATE,'') AS State
          ,ISNULL(ZIP,'') AS Zip
          ,ISNULL(COUNTRY,'') AS Country
          ,ISNULL(PhoneNumber,'') AS PhoneNumber
          ,ISNULL(MobileNumber,'') AS MobileNumber
          ,ISNULL(EMAIL,'') AS Email
          
      FROM @Results
  ORDER BY UpdatedDate DESC;    
  
  END 
  
-- EXECUTE [AHOBPR].[SP_ReportContactHistory] 5
GO
PRINT N'Altering [AHOBPR].[SP_ReportParticipation]...';


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: Dec 30, 2014
-- Description:	Used for the AHOBPR Participation Report       -- exec [AHOBPR].[SP_ReportParticipation] 
-- 20150330 - Bruce Clegg - Added VisnId value of NLA to find Null locations
-- 20150427 - Bruce Clegg - Change to LocationType and Key, for both Assigned and Evaluated Locations
-- 20150710 - Bruce Clegg - Rewrite using Dynamic SQL for Performance
-- 20150910 - Bruce Clegg - Removed selection for Question 1.2.A for Deployments
-- 20150915 - Bruce Clegg - Add Max Time to End date parameter
-- =============================================
ALTER PROCEDURE [AHOBPR].[SP_ReportParticipation]
       @StartDate DATETIME2(0) = NULL,  
       @EndDate   DATETIME2(0) = NULL,
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL   -- 'V16', 'V01'    1000109,  1000089
AS
BEGIN

  SET @StartDate = ISNULL(@StartDate,'19900802'); -- Desert Storm start date
  SET @EndDate = ISNULL(@EndDate, GETDATE());
    
  SET @EndDate = dbo.AddMaxTime(@EndDate);
  
  DECLARE @ConsentStatusCount INT = 0,
          @EligibleStatusCount INT = 0,
          @ParticipantStatusCount INT = 0,
          @HealthConcernsCount INT = 0,
          @NoHealthConcernsCount INT = 0,
          @RequestSeenCount INT = 0,
          @NoRequestSeenCount INT = 0,
          @DoNotKnowRequestSeenCount INT = 0,
          @VeteranServiceStatusCount INT = 0,
          @ActiveDutyServiceStatusCount INT = 0,
          @RetireeServiceStatusCount INT = 0,
          @Afgh911Count INT = 0,
          @Iraq911Count INT = 0,
          @SWA911Count INT = 0,
          @Pre911Count INT = 0,
          @Djibouti911Count INT = 0,
          @MedianDaysToParticipant DECIMAL(9,2) = 0;    
  
  DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0;

  DECLARE @Query NVARCHAR(MAX);
  DECLARE @Criteria VARCHAR(2000) = '';

IF @AssignedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@AssignedLocationKey) = 1
  SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
IF @EvaluatedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@EvaluatedLocationKey) = 1
  SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

  --  Build Criteria string

  SET @Criteria = ' AND responseStat.QUESTIONNAIRE_COMPLETED_DATE BETWEEN ''' + CONVERT(VARCHAR(20),@StartDate,121) +
                                                                    ''' AND ''' + CONVERT(VARCHAR(20),@EndDate,121) + ''' ' ;
  IF @AssignedLocationType = 'NLA' 
    SET @Criteria = @Criteria + ' AND reg.STD_INSTITUTION_ID IS NULL ';

  IF @AssignedLocationType = 'VISN' 
    SET @Criteria = @Criteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                      ' WHERE inst.ID = reg.STD_INSTITUTION_ID ' +
                                         'AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
 	
  IF @AssignedLocationType = 'Base' 
    SET @Criteria = @Criteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                       'WHERE inst.ID = reg.STD_INSTITUTION_ID ' +
                                         'AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ' ) ';
            	
  IF @AssignedLocationType = 'Institution' 
    SET @Criteria = @Criteria + ' AND reg.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ' '	
  
  IF @EvaluatedLocationType = 'NLA' 
    SET @Criteria = @Criteria + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                            'WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID ' +
                                               'AND eval.EVALUATION_FLAG = ''Y'' ) ';
          
  IF @EvaluatedLocationType = 'VISN' 
    SET @Criteria = @Criteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                               'JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                             ' WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID ' +
                                                'AND inst.VisnID = ''' +  @EvaluatedLocationKey + ''' ' +
                                                'AND eval.EVALUATION_FLAG = ''Y'') ' ; 
         	
  IF @EvaluatedLocationType = 'Base' 
    SET @Criteria = @Criteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                               'JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                             ' WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID ' +
                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + 
             	                          ' AND eval.EVALUATION_FLAG = ''Y'') '; 
  IF @EvaluatedLocationType = 'Institution' 
    SET @Criteria = @Criteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                      ' WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID '+
                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) +
                                        ' AND eval.EVALUATION_FLAG = ''Y'') '; 

  --  @ParticipantStatusCount
  SET @Query = ' SELECT @ParticipantStatusCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID '  
              + @Criteria     
              + '  AND stat.REGISTRANT_STATUS = ''Participant'' '; 
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@ParticipantStatusCount INT OUTPUT',    @ParticipantStatusCount OUTPUT;

   
    --  @HealthConcernsCount
  SET @Query = ' SELECT @HealthConcernsCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID '  
              + ' WHERE reg.HEALTH_CONCERNS_RESPONSE = ''Yes'' '
              + @Criteria; 
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@HealthConcernsCount INT OUTPUT',    @HealthConcernsCount OUTPUT;

  --  @NoHealthConcernsCount
  SET @Query = ' SELECT @NoHealthConcernsCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID '  
              + ' WHERE reg.HEALTH_CONCERNS_RESPONSE IS NULL '
              + @Criteria; 
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@NoHealthConcernsCount INT OUTPUT',    @NoHealthConcernsCount OUTPUT;
                           

  --  @RequestSeenCount
  SET @Query = ' SELECT @RequestSeenCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID '  
              + ' WHERE reg.REQUEST_SEEN_RESPONSE = ''Yes'' '
              + @Criteria;
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@RequestSeenCount INT OUTPUT',    @RequestSeenCount OUTPUT;
                                                     
  --  @NoRequestSeenCount
  SET @Query = ' SELECT @NoRequestSeenCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID '  
              + ' WHERE reg.REQUEST_SEEN_RESPONSE = ''No'' '
              + @Criteria;
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@NoRequestSeenCount INT OUTPUT',    @NoRequestSeenCount OUTPUT;
                                                                                         
  --  @DoNotKnowRequestSeenCount
  SET @Query = ' SELECT @DoNotKnowRequestSeenCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID '  
              + ' WHERE ISNULL(reg.REQUEST_SEEN_RESPONSE,'''') NOT IN (''Yes'',''No'') '
              + @Criteria;
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@DoNotKnowRequestSeenCount INT OUTPUT', @DoNotKnowRequestSeenCount OUTPUT;      
                                                   
  --  @ActiveDutyServiceStatusCount
  SET @Query = ' SELECT @ActiveDutyServiceStatusCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID ' +
                '  JOIN AHOBPR.STD_SERVICE_STATUS svc  ON svc.STD_SERVICE_STATUS_ID = reg.STD_SERVICE_STATUS_ID '
              + ' WHERE svc.SERVICE_STATUS = ''Active Duty'' '
              + @Criteria;
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@ActiveDutyServiceStatusCount INT OUTPUT', @ActiveDutyServiceStatusCount OUTPUT;        
         
   
  --  @VeteranServiceStatusCount
  SET @Query = ' SELECT @VeteranServiceStatusCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID ' +
                '  JOIN AHOBPR.STD_SERVICE_STATUS svc  ON svc.STD_SERVICE_STATUS_ID = reg.STD_SERVICE_STATUS_ID '
              + ' WHERE svc.SERVICE_STATUS = ''Separated'' '
              + @Criteria;
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@VeteranServiceStatusCount INT OUTPUT', @VeteranServiceStatusCount OUTPUT;                    
 
  --  @RetireeServiceStatusCount
  SET @Query = ' SELECT @RetireeServiceStatusCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID ' +
                '  JOIN AHOBPR.STD_SERVICE_STATUS svc  ON svc.STD_SERVICE_STATUS_ID = reg.STD_SERVICE_STATUS_ID '
              + ' WHERE svc.SERVICE_STATUS = ''Retiree'' '
              + @Criteria;
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@RetireeServiceStatusCount INT OUTPUT', @RetireeServiceStatusCount OUTPUT;                    
 
     
                                                         
-- Deployment Counts  
  SET @Query = 'WITH Deployments
  AS ( 
    SELECT 
        dply.REGISTRANT_ID ,
      CASE WHEN (SUM(CASE WHEN [DEPLOYMENT_COUNTRY] = ''Iraq'' 
                           AND [DEPLOYMENT_START_DATE] > ''20010911'' 
                           THEN 1 ELSE 0 END) )> 0 
           THEN 1 ELSE 0 END AS Iraq911Count,
      CASE WHEN (SUM(CASE WHEN [DEPLOYMENT_COUNTRY] = ''Afghanistan''  
                           AND [DEPLOYMENT_START_DATE] > ''20010911'' 
                          THEN 1 ELSE 0 END)) > 0
           THEN 1 ELSE 0 END AS Afgh911Count,              
      CASE WHEN (SUM(CASE WHEN [DEPLOYMENT_COUNTRY] = ''Djibouti''  
                           AND [DEPLOYMENT_START_DATE] > ''20010911'' 
                          THEN 1 ELSE 0 END)) > 0
           THEN 1 ELSE 0 END AS Djibouti911Count,              
      CASE WHEN (SUM(CASE WHEN [DEPLOYMENT_COUNTRY] IN (''Kuwait'',''Saudi Arabia'',''Bahrain'', ''Gulf of Aden'', ''Gulf of Oman'', ''Oman'', ''Qatar'', ''United Arab Emirates'', ''Persian Gulf'', ''Arabian Sea'', ''Red Sea'')
                           AND [DEPLOYMENT_START_DATE] > ''20010911'' 
                           THEN 1 ELSE 0 END)) > 0
           THEN 1 ELSE 0 END AS SWA911Count,
      CASE WHEN (SUM(CASE WHEN ([DEPLOYMENT_START_DATE] BETWEEN ''19900802'' AND ''20010911'' ) 
                           AND  [DEPLOYMENT_COUNTRY] IN (''Iraq'',''Kuwait'',''Saudi Arabia'',''Bahrain'', ''Gulf of Aden'', ''Gulf of Oman'', ''Oman'', ''Qatar'', ''United Arab Emirates'', ''Persian Gulf'', ''Arabian Sea'', ''Red Sea'')
                          THEN 1 ELSE 0 END)) > 0
           THEN 1 ELSE 0 END  AS Pre911Count
    FROM [AHOBPR].[REGISTRANT_DEPLOYMENT] dply
        JOIN AHOBPR.REGISTRANT Reg ON Reg.REGISTRANT_ID = dply.REGISTRANT_ID
        JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = dply.REGISTRANT_ID
        JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID   
	     WHERE 1 = 1 ' +
	     @Criteria +                
    ' GROUP BY dply.REGISTRANT_ID 
     )
     SELECT @Afgh911Count =  SUM(ISNULL(Deployments.Afgh911Count,0))  
           ,@Iraq911Count =  SUM(ISNULL(Deployments.Iraq911Count,0))
           ,@SWA911Count = SUM(ISNULL(Deployments.SWA911Count,0))
           ,@Pre911Count =   SUM(ISNULL(Deployments.Pre911Count,0))
           ,@Djibouti911Count = SUM(ISNULL(Deployments.Djibouti911Count,0))
      FROM Deployments' ;
      
  PRINT @Query;
  EXEC sp_executesql @Query,  
       N'@Afgh911Count INT OUTPUT, @Iraq911Count INT OUTPUT, @SWA911Count INT OUTPUT, @Pre911Count INT OUTPUT, @Djibouti911Count INT OUTPUT'
      , @Afgh911Count OUTPUT, @Iraq911Count OUTPUT, @SWA911Count OUTPUT, @Pre911Count OUTPUT, @Djibouti911Count OUTPUT;            

  
     CREATE TABLE #DaysToParticipant(DAYS INT);
   
    -- Median Days from Eligible to Participant Status    
    -- Note that only Registrants with Both values and DateParticipant > DateEligible will be counted for either Numerator or Denominator

    SET @Query = 'WITH eligible 
      AS ( 
          SELECT [REGISTRANT_ID],MIN([CREATED]) AS DateEligible
            FROM [AHOBPR].[PROCESS_METRICS]
           WHERE [PROCESS_METRICS_VALUE] = ''Eligible''
           GROUP BY [REGISTRANT_ID]
         ),
      participant 
      AS (
         SELECT [REGISTRANT_ID],MAX([CREATED]) AS DateParticipant
           FROM [AHOBPR].[PROCESS_METRICS]
          WHERE [PROCESS_METRICS_VALUE] = ''Participant''   
           GROUP BY [REGISTRANT_ID]
          )
     INSERT INTO #DaysToParticipant(DAYS)
    SELECT 
      CASE WHEN DateParticipant > DateEligible THEN DATEDIFF(Day,DateEligible,DateParticipant) ELSE 0 END AS DaysDifference
      FROM [AHOBPR].[REGISTRANT] reg
      JOIN eligible ON reg.REGISTRANT_ID = eligible.REGISTRANT_ID
      JOIN participant ON reg.REGISTRANT_ID = participant.REGISTRANT_ID   
      JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID
      JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID ' +
    'WHERE 1 = 1 '  + @Criteria +  
   ' ORDER BY DaysDifference';

  PRINT @Query;
  EXECUTE(@Query);
     
    WITH Counts AS
    (
       SELECT c=COUNT(*)
       FROM #DaysToParticipant
    )
    SELECT @MedianDaysToParticipant = AVG(0. + DAYS)
    FROM Counts a
    CROSS APPLY
    (
       SELECT TOP(((a.c - 1) / 2) + (1 + (1 - a.c % 2)))
          DAYS, r=ROW_NUMBER() OVER (ORDER BY DAYS)
       FROM #DaysToParticipant b
       ORDER BY DAYS
    ) p
    WHERE r BETWEEN ((a.c - 1) / 2) + 1 AND (((a.c - 1) / 2) + (1 + (1 - a.c % 2))); 
         
    DROP  TABLE #DaysToParticipant;                   
 
 -- Return Results
   SELECT ISNULL(@ParticipantStatusCount,0) AS ParticipantStatusCount,
          ISNULL(@HealthConcernsCount,0) AS ReportedHealthConcernsCount,
          ISNULL(@NoHealthConcernsCount,0) AS  NoReportedHealthConcernsCount,
          ISNULL(@RequestSeenCount,0) AS RequestSeenCount,
          ISNULL(@NoRequestSeenCount,0) AS NoRequestSeenCount,
          ISNULL(@DoNotKnowRequestSeenCount,0) AS DoNotKnowRequestSeenCount,
          ISNULL(@VeteranServiceStatusCount,0) AS VeteranServiceStatusCount ,
          ISNULL(@ActiveDutyServiceStatusCount,0) AS  ActiveDutyServiceStatusCount,
          ISNULL(@RetireeServiceStatusCount,0) AS RetireeServiceStatusCount,
          ISNULL(@Afgh911Count,0) AS  Afgh911Count,
          ISNULL(@Iraq911Count,0) AS Iraq911Count,
          ISNULL(@SWA911Count,0) AS  SouthWestAsia911Count,
          ISNULL(@Pre911Count,0) AS  Pre911Count,
          ISNULL(@MedianDaysToParticipant,0.0) AS MedianDaysToParticipant,
          ISNULL(@Djibouti911Count,0) AS Djibouti911Count ;

END

-- exec [AHOBPR].[SP_ReportParticipation] @StartDate = '20150901'
-- exec [AHOBPR].[SP_ReportParticipation] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportParticipation] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportParticipation] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportParticipation] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportParticipation]
-- exec [AHOBPR].[SP_ReportParticipation] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportParticipation] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportParticipation] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportParticipation] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'
GO
PRINT N'Update complete.';


GO

DELETE 
  FROM [dbo].[DatabaseChangeLog]
  WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber] = '$(PointReleaseNumber)'
    AND [ScriptName]         = '$(ScriptName)';
GO

------------------------------------------
------------------------------------------
-- 2.0.9.1
------------------------------------------
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "9"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.9.1.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
Rollback $(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
SET NOEXEC OFF; 
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO

USE [$(DatabaseName)]
GO

--**************
--Rollback steps
--**************
--
UPDATE  [dbo].[DatabaseChangeLog]
  SET [ScriptDescription] = 'Rollback initiatited...'
  WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber] = '$(PointReleaseNumber)'
    AND [ScriptName]         = '$(ScriptName)';
GO

IF EXISTS (select * from sys.procedures where name = 'SP_GetFailedtoSendQuestions'
                AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
  DROP PROCEDURE [AHOBPR].[SP_GetFailedtoSendQuestions];

GO
DELETE 
  FROM [dbo].[DatabaseChangeLog]
  WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber] = '$(PointReleaseNumber)'
    AND [ScriptName]         = '$(ScriptName)';
GO

------------------------------------------
------------------------------------------
-- 2.0.8.1
------------------------------------------
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "8"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.8.1.sql"
-- Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
SET NOEXEC OFF; SET NOCOUNT OFF;
:setvar __IsSqlCmdEnabled "True"
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True' BEGIN
    PRINT     '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
    RAISERROR('SQLCMD mode must be enabled to successfully execute this script.', 11, 0); PRINT     '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'     
    SET NOCOUNT ON; SET NOEXEC ON; --this is necessary because SQLCMD mode is not and therefore so on error exit cannot be used
END
GO


PRINT ' 
------------------------------------------------------------------------------------------------
Rollback $(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit

USE [$(DatabaseName)]
GO

--**************
--Rollback steps
--**************
--

UPDATE [dbo].[DatabaseChangeLog]
  SET ScriptDescription = 'Rollback initiated...'
  WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber] = '$(PointReleaseNumber)'
    AND [ScriptName]         = '$(ScriptName)';
GO
if exists (select * from sys.views where name = 'VIEW_LOOKUP_Pre_2_0_8_1'
                AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
begin
  begin try
    begin transaction;
    if exists (select * from sys.views where name = 'VIEW_LOOKUP'
                and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
              )
      drop view [AHOBPR].VIEW_LOOKUP;
  
    exec sp_rename 'AHOBPR.VIEW_LOOKUP_Pre_2_0_8_1', 'VIEW_LOOKUP';
    commit;
  end try
  begin catch
    rollback;
    raiserror('!!! Error: The procedure VIEW_LOOKUP was not rolled back. The script execution was stopped.  You must back out the changes, fix the error and run it again. !!!',11
              ,1);
    set nocount on;
    set noexec on;
  end catch
end;
go

IF EXISTS (select * from sys.procedures where name = 'SP_DeleteRegistrantAndResponse_Pre_2_0_8_1'
                AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
BEGIN
  BEGIN TRY
    BEGIN TRANSACTION;
    if exists (select * from sys.procedures where name = 'SP_DeleteRegistrantAndResponse'
                AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
              )
      DROP PROCEDURE [AHOBPR].SP_DeleteRegistrantAndResponse;
  
    EXEC sp_rename 'AHOBPR.SP_DeleteRegistrantAndResponse_Pre_2_0_8_1', 'SP_DeleteRegistrantAndResponse';
    COMMIT;
  END TRY
  BEGIN CATCH
    ROLLBACK;
    RAISERROR('!!! Error: The procedure SP_DeleteRegistrantAndResponse was not rolled back. The script execution was stopped.  You must back out the changes, fix the error and run it again. !!!',11
              ,2);
    SET NOCOUNT ON;
    SET NOEXEC ON;
  END CATCH
END;
GO

IF EXISTS (select * from sys.procedures where name = 'SP_DeleteOneRegistrant_Pre_2_0_8_1'
                AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
BEGIN
  BEGIN TRY
    BEGIN TRANSACTION;
    if exists (select * from sys.procedures where name = 'SP_DeleteOneRegistrant'
                AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
              )
      DROP PROCEDURE [AHOBPR].SP_DeleteOneRegistrant;
  
    EXEC sp_rename 'AHOBPR.SP_DeleteOneRegistrant_Pre_2_0_8_1', 'SP_DeleteOneRegistrant';
    COMMIT;
  END TRY
  BEGIN CATCH
    ROLLBACK;
    RAISERROR('!!! Error: The procedure SP_DeleteOneRegistrant was not rolled back. The script execution was stopped.  You must back out the changes, fix the error and run it again. !!!',11
              ,3);
    SET NOCOUNT ON;
    SET NOEXEC ON;
  END CATCH
END;
GO
DELETE 
  FROM [dbo].[DatabaseChangeLog]
  WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber] = '$(PointReleaseNumber)'
    AND [ScriptName]         = '$(ScriptName)';
GO
-----------------------------------------------------------
-----------------------------------------------------------
-- 2.0.4.3
-----------------------------------------------------------
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "4"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.4.3.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
Rollback $(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
go
:on error exit
go
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
set noexec off; 
go
if N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
begin
    print N'SQLCMD mode must be enabled to successfully execute this script.';
    set noexec on; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
end

go

use [$(DatabaseName)]
go

--**************
--Rollback steps
--**************
--
update  [dbo].[DatabaseChangeLog]
  set [ScriptDescription] = 'Rollback initiated...'
  where [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    and [PointReleaseNumber] = '$(PointReleaseNumber)'
    and [ScriptName]         = '$(ScriptName)';
go
set ansi_nulls, ansi_padding, ansi_warnings, arithabort, concat_null_yields_null, quoted_identifier on;

set numeric_roundabort off;

go

if exists (select * from sys.procedures where name = 'SP_GetJsonQueueFollowupRow'
          and schema_id = (select schema_id from [sys].[schemas] where name = 'AHOBPR') 
          )
begin
  print 'Drop procedure AHOBPR.SP_GetJsonQueueFollowupRow...';
  drop procedure ahobpr.SP_GetJsonQueueFollowupRow;
end;

go
print N'$(ScriptName) Rollback complete.';
go

delete 
  from [dbo].[DatabaseChangeLog]
  where [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    and [PointReleaseNumber] = '$(PointReleaseNumber)'
    and [ScriptName]         = '$(ScriptName)';
go
-----------------------------------------------------------
-----------------------------------------------------------
-- 2.0.4.2
-----------------------------------------------------------
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "4"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.4.2.sql"
--select * from [dbo].[DatabaseChangeLog] where [ScriptName] = 'Registry.AHOBPR.Database.Build.2.0.4.2.sql'
PRINT ' 
------------------------------------------------------------------------------------------------
Rollback $(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO

USE [$(DatabaseName)]
GO

--**************
--Rollback steps
--**************
--

UPDATE [dbo].[DatabaseChangeLog]
  SET ScriptDescription = 'Rollback initiated...'
  WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber] = '$(PointReleaseNumber)'
    AND [ScriptName]         = '$(ScriptName)';
GO
GO

IF EXISTS (select * from sys.views where name = 'VIEW_REGISTRANT_DEPLOYMENT'                
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
               )
BEGIN
  DROP VIEW [AHOBPR].VIEW_REGISTRANT_DEPLOYMENT;
END;
GO

IF EXISTS (select * from sys.views where name = 'VIEW_REGISTRANT_EVALUATION'                
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
               )
BEGIN
  DROP VIEW [AHOBPR].VIEW_REGISTRANT_EVALUATION;
END;
GO

IF EXISTS (select * from sys.views where name = 'VIEW_REGISTRANT_VISIT'                
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
               )
BEGIN
  DROP VIEW [AHOBPR].VIEW_REGISTRANT_VISIT;
END;

GO
IF EXISTS (select * from sys.views where name = 'VIEW_REGISTRANT_ANSWER'                
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
               )
BEGIN
  DROP VIEW [AHOBPR].VIEW_REGISTRANT_ANSWER;
END;
GO
IF EXISTS (select * from sys.views where name = 'VIEW_REGISTRANT_QUESTION'                
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
               )
BEGIN
  DROP VIEW [AHOBPR].VIEW_REGISTRANT_QUESTION;
END;
GO
IF EXISTS (select * from sys.views where name = 'VIEW_REGISTRANT_STATUS_OLD'                
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
BEGIN
  IF EXISTS (select * from sys.views where name = 'VIEW_REGISTRANT_STATUS'                
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
            )
  BEGIN
    DROP VIEW AHOBPR.VIEW_REGISTRANT_STATUS;
  END;
  EXEC SP_RENAME 'AHOBPR.VIEW_REGISTRANT_STATUS_OLD', 'VIEW_REGISTRANT_STATUS';
END;
GO
if exists (select * from sys.views where name = 'VIEW_REGISTRANT'                
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
begin
  drop view [AHOBPR].VIEW_REGISTRANT;
end;
if exists (select * from sys.views where name = 'VIEW_REGISTRANT_pre_2_0_4_2' 
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
begin
  exec sp_rename 'ahobpr.VIEW_REGISTRANT_pre_2_0_4_2', 'VIEW_REGISTRANT';
end;

GO
IF EXISTS (select * from sys.views where name = 'VIEW_REGISTRANT_DEPLOYMENT_EXPOSURE_RESPONSE'                
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
               )
BEGIN
  DROP VIEW [AHOBPR].VIEW_REGISTRANT_DEPLOYMENT_EXPOSURE_RESPONSE;
END;
GO
DELETE 
  FROM [dbo].[DatabaseChangeLog]
  WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber] = '$(PointReleaseNumber)'
    AND [ScriptName]         = '$(ScriptName)';
go
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "4"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.4.1.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
Rollback $(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO

USE [$(DatabaseName)]
GO

--**************
--Rollback steps
--**************
--
DELETE 
--select *
  FROM [dbo].[DatabaseChangeLog]
  WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber] = '$(PointReleaseNumber)'
    AND [ScriptName]         = '$(ScriptName)';

--22
IF EXISTS (select * from sys.procedures where name = 'SP_GetRegistrantSendMessage_Pre_2_0_4_1'                
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
               )
BEGIN
  if exists (select * from sys.procedures where name = 'SP_GetRegistrantSendMessage'                
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
               )
    DROP PROCEDURE AHOBPR.SP_GetRegistrantSendMessage;
  exec sp_rename 'AHOBPR.SP_GetRegistrantSendMessage_Pre_2_0_4_1', 'SP_GetRegistrantSendMessage';
END;
--21
IF EXISTS (select * from sys.views where name = 'VIEW_LOOKUP_Pre_2_0_4_1'                
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
               )
BEGIN
  IF EXISTS (select * from sys.views where name = 'VIEW_LOOKUP'                
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
               )
    drop view ahobpr.VIEW_LOOKUP;
  exec sp_rename 'AHOBPR.VIEW_LOOKUP_Pre_2_0_4_1','VIEW_LOOKUP';
END;
GO
--20
IF EXISTS (SELECT * FROM sys.procedures WHERE name = 'SP_GetJsonQueueFollowup'
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
BEGIN
  DROP PROCEDURE [AHOBPR].SP_GetJsonQueueFollowup;
END;
GO
--19
IF EXISTS (SELECT * FROM sys.procedures WHERE name = 'SP_InsertJsonQueueFollowup'
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
BEGIN
  DROP PROCEDURE [AHOBPR].SP_InsertJsonQueueFollowup;
END;
GO
--18
IF EXISTS (SELECT * FROM sys.procedures WHERE name = 'SP_GetRegistrantJsonFollowupRow'
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
BEGIN
  DROP PROCEDURE [AHOBPR].SP_GetRegistrantJsonFollowupRow;
END;
GO
--17
IF EXISTS (SELECT * FROM sys.procedures WHERE name = 'SP_GetJsonFollowup'
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
BEGIN
  DROP PROCEDURE [AHOBPR].SP_GetJsonFollowup;
END;
GO
--16
IF EXISTS (SELECT * FROM sys.procedures WHERE name = 'SP_GetJsonFollowups'
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
BEGIN
  DROP PROCEDURE [AHOBPR].SP_GetJsonFollowups;
END;
GO
--15
IF EXISTS (SELECT * FROM sys.tables WHERE name = 'FOLLOWUP_FORM_RESPONSE_ANSWER'
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
BEGIN
  DROP TABLE [AHOBPR].FOLLOWUP_FORM_RESPONSE_ANSWER;
END;
GO
--14
IF EXISTS (SELECT * FROM sys.tables WHERE name = 'FOLLOWUP_FORM_RESPONSE_QUESTION'
             AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
BEGIN
  DROP TABLE [AHOBPR].FOLLOWUP_FORM_RESPONSE_QUESTION;
END;
GO
--13
IF EXISTS (SELECT * FROM sys.tables WHERE name = 'FOLLOWUP_FORM_RESPONSE'
             AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
BEGIN
  DROP TABLE [AHOBPR].FOLLOWUP_FORM_RESPONSE;
END;
GO
--12
IF EXISTS (SELECT * FROM sys.procedures WHERE name = 'SP_GetRegistrantSendQuestions'
            AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
BEGIN
  DROP PROCEDURE AHOBPR.SP_GetRegistrantSendQuestions;
END;
--11
IF EXISTS (SELECT * FROM sys.procedures WHERE name = 'SP_InsertRegistrantJsonFollowup'
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
BEGIN 
  DROP PROCEDURE AHOBPR.SP_InsertRegistrantJsonFollowup;
END;
GO
--10
IF EXISTS (select * from sys.tables where name = 'JSON_QUEUE_FOLLOWUP_STATUS'
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
BEGIN
  DROP TABLE [AHOBPR].JSON_QUEUE_FOLLOWUP_STATUS;
END;
GO
--9
IF EXISTS (select * from sys.tables where name = 'JSON_QUEUE_FOLLOWUP'
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
               )
BEGIN
  DROP TABLE AHOBPR.JSON_QUEUE_FOLLOWUP;
END;
GO
--8
IF EXISTS (select * from sys.tables where name = 'REGISTRANT_JSON_FOLLOWUP'
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
               )
BEGIN
  DROP TABLE AHOBPR.REGISTRANT_JSON_FOLLOWUP;
END;
GO
--7
IF EXISTS (select * from sys.columns where name = 'TOOL_FORM_ID'
                AND object_id = (select object_id from sys.tables where name = 'STD_FORM'
                                  AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
                                )
               )
BEGIN
  ALTER 
    TABLE [AHOBPR].STD_FORM
    DROP COLUMN TOOL_FORM_ID;
END;
GO
--6
IF EXISTS (select * from sys.columns where name = 'FOLLOWUP_FLAG'
                AND object_id = (select object_id from sys.tables where name = 'STD_FORM'
                                  AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
                                )
               )
BEGIN
  begin try
    if exists (select * from sys.default_constraints where name = 'DF_STD_FORM_FOLLOWUP_FLAG'
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
              )
      ALTER TABLE [AHOBPR].STD_FORM
        DROP CONSTRAINT DF_STD_FORM_FOLLOWUP_FLAG;
    ALTER 
      TABLE [AHOBPR].STD_FORM
      DROP COLUMN FOLLOWUP_FLAG;
  end try
  begin catch
    print 'FOLLOWUP_FLAG column not deleted'
  end catch;
END;
GO
--5
IF EXISTS (SELECT * FROM sys.tables WHERE name = 'TOOL_ANSWER'
            AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
  DROP TABLE [AHOBPR].TOOL_ANSWER;
GO
--4
IF EXISTS (SELECT * FROM sys.tables WHERE name = 'TOOL_FORM_QUESTION'
            AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
  DROP TABLE [AHOBPR].[TOOL_FORM_QUESTION];
GO
--3
IF EXISTS (SELECT * FROM sys.tables WHERE name = 'TOOL_QUESTION'
            AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
  DROP TABLE [AHOBPR].[TOOL_QUESTION];
GO
--2
IF EXISTS (SELECT * FROM sys.tables WHERE name = 'TOOL_FORM'
            AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
  DROP TABLE AHOBPR.[TOOL_FORM];
GO
-- Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
SET NOEXEC OFF; SET NOCOUNT OFF;
:setvar __IsSqlCmdEnabled "True"
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True' BEGIN
    PRINT     '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
    RAISERROR('SQLCMD mode must be enabled to successfully execute this script.', 11, 0); PRINT     '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'     
    SET NOCOUNT ON; SET NOEXEC ON; --this is necessary because SQLCMD mode is not and therefore so on error exit cannot be used
END
GO
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "2"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.2.2.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Rollback script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit

use [$(DatabaseName)]

if exists (select * from sys.views where name = 'VIEW_REGISTRANT_STATUS_Pre_2_0_2_2'
)
begin
  if exists (select * from sys.views where name = 'VIEW_REGISTRANT_STATUS'
              and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            )
    drop view ahobpr.VIEW_REGISTRANT_STATUS;
  exec sp_rename 'AHOBPR.VIEW_REGISTRANT_STATUS_Pre_2_0_2_2', 'VIEW_REGISTRANT_STATUS';
end;
go
delete 
  from [dbo].[DatabaseChangeLog]
  where [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber] = '$(PointReleaseNumber)'
    AND [ScriptName]         = '$(ScriptName)';
GO


-- Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
SET NOEXEC OFF; SET NOCOUNT OFF;
:setvar __IsSqlCmdEnabled "True"
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True' BEGIN
    PRINT     '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
    RAISERROR('SQLCMD mode must be enabled to successfully execute this script.', 11, 0); PRINT     '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'     
    SET NOCOUNT ON; SET NOEXEC ON; --this is necessary because SQLCMD mode is not and therefore so on error exit cannot be used
END
GO



--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "2"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.2.1.sql"

-- Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
SET NOEXEC OFF; SET NOCOUNT OFF;
:setvar __IsSqlCmdEnabled "True"
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True' BEGIN
    PRINT     '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
    RAISERROR('SQLCMD mode must be enabled to successfully execute this script.', 11, 0); PRINT     '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'     
    SET NOCOUNT ON; SET NOEXEC ON; --this is necessary because SQLCMD mode is not and therefore so on error exit cannot be used
END
GO


PRINT ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Rollback script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
USE $(DatabaseName)
--**************
--Rollback steps
--**************
UPDATE [dbo].[DatabaseChangeLog]
  SET ScriptDescription = 'Rollback initiated...'
  WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber] = '$(PointReleaseNumber)'
    AND [ScriptName]         = '$(ScriptName)';
GO
IF EXISTS (select * from sys.procedures where name = 'SP_GetRegistrantSendMessage')
  DROP PROCEDURE AHOBPR.SP_GetRegistrantSendMessage;
GO
IF EXISTS (select * from sys.columns join sys.tables on tables.object_id = columns.object_id
            where columns.name = 'email' and tables.name = 'EMAIL_TEMPLATES')
BEGIN
  IF EXISTS (select * from sys.default_constraints
              where name = 'DF_EMAIL_TEMPLATES_Email' and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            )
    ALTER TABLE AHOBPR.EMAIL_TEMPLATES
      DROP CONSTRAINT DF_EMAIL_TEMPLATES_Email;
  ALTER 
      TABLE AHOBPR.EMAIL_TEMPLATES
	    DROP COLUMN  [EMAIL];
END;
GO
IF EXISTS (select * from sys.columns join sys.tables on tables.object_id = columns.object_id
            where columns.name = 'notification' and tables.name = 'EMAIL_TEMPLATES')
BEGIN
  IF EXISTS (select * from sys.default_constraints
              where name = 'DF_EMAIL_TEMPLATES_Notification' and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            )
    ALTER TABLE AHOBPR.EMAIL_TEMPLATES
      DROP CONSTRAINT DF_EMAIL_TEMPLATES_Notification;

  ALTER 
      TABLE AHOBPR.EMAIL_TEMPLATES
	    DROP COLUMN  [NOTIFICATION];
END;
GO

IF EXISTS (select * from sys.views where name = 'VIEW_REGISTRANT_STATUS'                          
                AND schema_id = (select schema_id FROM sys.schemas WHERE name = 'AHOBPR')
          )
  DROP VIEW [AHOBPR].[VIEW_REGISTRANT_STATUS];
GO
DELETE FROM [dbo].[DatabaseChangeLog]
          WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
            AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
            AND [PointReleaseNumber] = '$(PointReleaseNumber)'
            AND [ScriptName]         = '$(ScriptName)';
GO

-------------------------------------------
---- END ROLLBACK 
-------------------------------------------
SELECT 'Last script run and not rolled back',*
FROM [dbo].[DatabaseChangeLog]
WHERE  [DatabaseChangeID] = (
                              SELECT MAX([DatabaseChangeID]) FROM [dbo].[DatabaseChangeLog]
                              WHERE TargetRegistry        = 'AHOBPR'
                             );
